package com.biz.crm.tpm.business.variable.local.register.configure.common;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmProfitabilityAnalysisDto;
import com.biz.crm.tpm.business.third.system.sdk.service.TpmProfitabilityAnalysisService;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmProfitabilityAnalysisVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariableCommonConstants;
import com.biz.crm.tpm.business.variable.local.repository.ConVariableDetailRepository;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.ConVariableDetailDto;
import com.biz.crm.tpm.business.variable.sdk.enums.ConItemTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-18
 */
@Slf4j
@Component
public class ConVariableRegisterParamHandler {

    @Autowired(required = false)
    private ConVariableDetailRepository conVariableDetailRepository;

    @Autowired(required = false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;

    @Autowired(required = false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;

    @Autowired(required = false)
    private TpmProfitabilityAnalysisService tpmProfitabilityAnalysisService;

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    /**
     * 全品全月销售量（不含2C奶卡）剔量、全品全月销售量（含奶卡）剔量、全月全品折后销售量（不含奶卡）剔量
     * 查主体日销售数据-剔量
     *
     * @param calculateDto
     * @param variableCode
     * @return
     */
    public List<MainOnedaySalesDataVo> findExcludeData(CalculateDto calculateDto, String variableCode) {
        String auditFormulaCode = calculateDto.getAuditFormulaCode();
        Assert.hasText(auditFormulaCode, "核销公式编码不能为空");
        Assert.notEmpty(calculateDto.getCustomerCodeList(), "客户编码不能为空");
        Assert.hasText(calculateDto.getBusinessUnitCode(), "业务单元不能为空");
        Assert.hasText(calculateDto.getBusinessFormatCode(), "业态不能为空");
        //查询非包含配置
        ConVariableDetailDto detailDto = new ConVariableDetailDto();
        detailDto.setAuditFormulaCode(auditFormulaCode);
        detailDto.setVariableCode(variableCode);
        List<ConVariableDetailVo> itemDetail = this.conVariableDetailRepository.getItemDetail(detailDto);
        MainOnedaySalesDataDto salesDataDto = new MainOnedaySalesDataDto();
        salesDataDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        salesDataDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesDataDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        if (!CollectionUtils.isEmpty(itemDetail)) {
            List<ConVariableDetailVo> filterList = itemDetail.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterList)) {
                ConVariableDetailVo variableDetailVo = itemDetail.get(0);
                salesDataDto.setStartTimeOrDate(DateUtil.format(variableDetailVo.getBeginTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
                salesDataDto.setEndTimeOrDate(DateUtil.format(variableDetailVo.getEndTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            }
            salesDataDto.setExcludeProductCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.GOODS));
            salesDataDto.setExcludeProductItemCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.ITEM));
            salesDataDto.setExcludeProductCategoryCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.CATEGORY));
            salesDataDto.setExcludeProductBrandCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.BRAND));
        }
        if (StringUtils.isEmpty(salesDataDto.getStartTimeOrDate()) && StringUtils.isEmpty(salesDataDto.getEndTimeOrDate())) {
            Assert.notNull(calculateDto.getStartTimeOrDate(), "活动开始时间不能为空");
            Assert.notNull(calculateDto.getEndTimeOrDate(), "活动结束时间不能为空");
            salesDataDto.setStartTimeOrDate(DateUtil.format(calculateDto.getStartTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            salesDataDto.setEndTimeOrDate(DateUtil.format(calculateDto.getEndTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
        }
        salesDataDto.setStartTimeOrDate(salesDataDto.getStartTimeOrDate().replaceAll("-", ""));
        salesDataDto.setEndTimeOrDate(salesDataDto.getEndTimeOrDate().replaceAll("-", ""));
        return mainOnedaySaleDataService.listMainOnedaySalesData(salesDataDto);
    }

    /**
     * 全月指定产品折后销售量（含奶卡）
     * 查主体日销售数据-包含+剔量
     *
     * @param calculateDto
     * @param variableCode
     * @return
     */
    public List<MainOnedaySalesDataVo> findIncludeData(CalculateDto calculateDto, String variableCode) {
        String auditFormulaCode = calculateDto.getAuditFormulaCode();
        Assert.hasText(auditFormulaCode, "核销公式编码不能为空");
        Assert.notEmpty(calculateDto.getCustomerCodeList(), "客户编码不能为空");
        Assert.hasText(calculateDto.getBusinessUnitCode(), "业务单元不能为空");
        Assert.hasText(calculateDto.getBusinessFormatCode(), "业态不能为空");
        //查询非包含配置
        ConVariableDetailDto detailDto = new ConVariableDetailDto();
        detailDto.setAuditFormulaCode(auditFormulaCode);
        detailDto.setVariableCode(variableCode);
        List<ConVariableDetailVo> itemDetail = this.conVariableDetailRepository.getItemDetail(detailDto);
        MainOnedaySalesDataDto salesDataDto = new MainOnedaySalesDataDto();
        salesDataDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        salesDataDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesDataDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        if (!CollectionUtils.isEmpty(itemDetail)) {
            List<ConVariableDetailVo> filterList = itemDetail.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterList)) {
                ConVariableDetailVo variableDetailVo = itemDetail.get(0);
                salesDataDto.setStartTimeOrDate(DateUtil.format(variableDetailVo.getBeginTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
                salesDataDto.setEndTimeOrDate(DateUtil.format(variableDetailVo.getEndTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            }
            salesDataDto.setProductCodes(this.getExcludeList(itemDetail, ConItemTypeEnum.INCLUDE_GOODS));
            salesDataDto.setExcludeProductCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.GOODS));
            salesDataDto.setExcludeProductItemCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.ITEM));
            salesDataDto.setExcludeProductCategoryCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.CATEGORY));
            salesDataDto.setExcludeProductBrandCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.BRAND));
        }
        if (CollectionUtils.isEmpty(salesDataDto.getProductCodes())) {
            if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
                salesDataDto.setProductCodes(Arrays.asList(calculateDto.getProductCode().split(",")));
            } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
                salesDataDto.setProductItemCode(calculateDto.getItemCode());
            } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
                salesDataDto.setProductCategoryCode(calculateDto.getCategoryCode());
            } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode()) && !StringUtils.equals(VariableCommonConstants.allBrandCode, calculateDto.getBrandCode())) {
                salesDataDto.setProductBrandCode(calculateDto.getBrandCode());
            } else if (StringUtils.isEmpty(calculateDto.getBrandCode())) {
                throw new RuntimeException("产品和产品层级全部为空！");
            }
        }

        if (StringUtils.isEmpty(salesDataDto.getStartTimeOrDate()) && StringUtils.isEmpty(salesDataDto.getEndTimeOrDate())) {
            Assert.notNull(calculateDto.getStartTimeOrDate(), "活动开始时间不能为空");
            Assert.notNull(calculateDto.getEndTimeOrDate(), "活动结束时间不能为空");
            salesDataDto.setStartTimeOrDate(DateUtil.format(calculateDto.getStartTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            salesDataDto.setEndTimeOrDate(DateUtil.format(calculateDto.getEndTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
        }
        salesDataDto.setStartTimeOrDate(salesDataDto.getStartTimeOrDate().replaceAll("-", ""));
        salesDataDto.setEndTimeOrDate(salesDataDto.getEndTimeOrDate().replaceAll("-", ""));
        return mainOnedaySaleDataService.listMainOnedaySalesData(salesDataDto);
    }

    /**
     * 分子公司出库折后销售额全部销额剔量
     * 099报表
     *
     * @param calculateDto
     * @param variableCode
     * @return
     */
    public BigDecimal findProfitabilityAnalysisFilterData(CalculateDto calculateDto, String variableCode) {
        String auditFormulaCode = calculateDto.getAuditFormulaCode();
        Assert.hasText(auditFormulaCode, "核销公式编码不能为空");
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码不能为空");

        //根据客户MDG编码获取销售机构编码
        List<SalesOrgSubComOrgVo> subComOrgVos = salesOrgSubComOrgService.listBySubComOrgCodeList(Lists.newArrayList(calculateDto.getCustomerErpCode()));
        Validate.notEmpty(subComOrgVos, "未获取到分子公司与销售机构对应关系");
        String salesOrgCode = subComOrgVos.get(0).getSalesOrgCode();

        //查询非包含配置
        ConVariableDetailDto detailDto = new ConVariableDetailDto();
        detailDto.setAuditFormulaCode(auditFormulaCode);
        detailDto.setVariableCode(variableCode);
        List<ConVariableDetailVo> itemDetail = this.conVariableDetailRepository.getItemDetail(detailDto);

        //查询参数
        TpmProfitabilityAnalysisDto dto = new TpmProfitabilityAnalysisDto();
        dto.setCompanyCode(salesOrgCode);
        dto.setSpartCode(VariableCommonConstants.spartCode);
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            dto.setMaterialCodes(Arrays.asList(calculateDto.getProductCode().split(",")));
        }

        Map<String, BigDecimal> pointMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(itemDetail)) {
            Map<String, BigDecimal> map = itemDetail.stream()
                    .filter(e -> ConItemTypeEnum.INCLUDE_GOODS.getCode().equals(e.getItemType()))
                    .collect(Collectors.toMap(ConVariableDetailVo::getItemCode,
                            e -> {
                                if (Objects.isNull(e.getPoint())) {
                                    return BigDecimal.ONE;
                                }
                                return e.getPoint();
                            }));
            pointMap.putAll(map);
            List<ConVariableDetailVo> filterList = itemDetail.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterList)) {
                ConVariableDetailVo variableDetailVo = filterList.get(0);
                dto.setAccountDateBegin(DateUtil.format(variableDetailVo.getBeginTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
                dto.setAccountDateEnd(DateUtil.format(variableDetailVo.getEndTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            }
            List<String> includeProductList = this.getExcludeList(itemDetail, ConItemTypeEnum.INCLUDE_GOODS);
            if (CollectionUtils.isEmpty(includeProductList)) {
                dto.setExcludeMaterialCodes(this.getExcludeList(itemDetail, ConItemTypeEnum.GOODS));
                dto.setExcludeItemCodes(this.getExcludeList(itemDetail, ConItemTypeEnum.ITEM));
                dto.setExcludeCategoryCodes(this.getExcludeList(itemDetail, ConItemTypeEnum.CATEGORY));
                dto.setExcludeBrandCodes(this.getExcludeList(itemDetail, ConItemTypeEnum.BRAND));
            } else {
                dto.setMaterialCodes(includeProductList);
            }
        } else {
            return BigDecimal.ZERO;
        }
        if (StringUtils.isEmpty(dto.getAccountDateBegin()) && StringUtils.isEmpty(dto.getAccountDateEnd())) {
            Assert.notNull(calculateDto.getStartTimeOrDate(), "活动开始时间不能为空");
            Assert.notNull(calculateDto.getEndTimeOrDate(), "活动结束时间不能为空");
            dto.setAccountDateBegin(DateUtil.format(calculateDto.getStartTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            dto.setAccountDateEnd(DateUtil.format(calculateDto.getEndTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
        }
        dto.setAccountDateBegin(dto.getAccountDateBegin().replaceAll("-", ""));
        dto.setAccountDateEnd(dto.getAccountDateEnd().replaceAll("-", ""));
        List<TpmProfitabilityAnalysisVo> vos = tpmProfitabilityAnalysisService.listForVariable(dto);
        if (CollectionUtils.isEmpty(vos)) {
            return BigDecimal.ZERO;
        }
        BigDecimal total = vos.stream()
                .filter(e -> Objects.nonNull(e.getActualIncomeIntax()))
                .map(e -> {
                    return e.getActualIncomeIntax().multiply(pointMap.getOrDefault(e.getMaterialCode(), BigDecimal.ONE));
                })
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        return total;
    }

    /**
     * 全月全品折后任务量剔量
     * 查询销售任务-剔量
     *
     * @param calculateDto
     * @param variableCode
     * @return
     */
    public List<SalesGoalVo> findExcludeSalesGoalData(CalculateDto calculateDto, String variableCode) {
        String auditFormulaCode = calculateDto.getAuditFormulaCode();
        Assert.hasText(auditFormulaCode, "核销公式编码不能为空");
        Assert.notEmpty(calculateDto.getCustomerCodeList(), "客户编码不能为空");
        Assert.hasText(calculateDto.getBusinessUnitCode(), "业务单元不能为空");
        Assert.hasText(calculateDto.getBusinessFormatCode(), "业态不能为空");
        //查询非包含配置
        ConVariableDetailDto detailDto = new ConVariableDetailDto();
        detailDto.setAuditFormulaCode(auditFormulaCode);
        detailDto.setVariableCode(variableCode);
        List<ConVariableDetailVo> itemDetail = this.conVariableDetailRepository.getItemDetail(detailDto);
        SalesGoalDto salesGoalDto = new SalesGoalDto();
        salesGoalDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        salesGoalDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesGoalDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        Date startTimeOrDate = null;
        Date endTimeOrDate = null;
        if (!CollectionUtils.isEmpty(itemDetail)) {
            List<ConVariableDetailVo> filterList = itemDetail.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterList)) {
                ConVariableDetailVo variableDetailVo = itemDetail.get(0);
                startTimeOrDate = variableDetailVo.getBeginTime();
                endTimeOrDate = variableDetailVo.getEndTime();
            }
            salesGoalDto.setExcludeProductCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.GOODS));
            salesGoalDto.setExcludeProductItemCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.ITEM));
            salesGoalDto.setExcludeProductCategoryCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.CATEGORY));
            salesGoalDto.setExcludeProductBrandCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.BRAND));
        }
        if (Objects.isNull(startTimeOrDate) && Objects.isNull(endTimeOrDate)) {
            Assert.notNull(calculateDto.getStartTimeOrDate(), "活动开始时间不能为空");
            Assert.notNull(calculateDto.getEndTimeOrDate(), "活动结束时间不能为空");
            startTimeOrDate = calculateDto.getStartTimeOrDate();
            endTimeOrDate = calculateDto.getEndTimeOrDate();
        }
        List<String> yearMonths = DateUtil.getBetweenYearMonths(startTimeOrDate, endTimeOrDate, DateUtil.DEFAULT_YEAR_MONTH);
        salesGoalDto.setYearMonthLySet(Sets.newHashSet(yearMonths));
        return salesGoalService.listForVariableCal(salesGoalDto);
    }


    /**
     * 指定时间指定产品折后任务量
     * 查询销售任务-包含
     *
     * @param calculateDto
     * @param variableCode
     * @return
     */
    public List<SalesGoalVo> findIncludeSalesGoalData(CalculateDto calculateDto, String variableCode) {
        String auditFormulaCode = calculateDto.getAuditFormulaCode();
        Assert.hasText(auditFormulaCode, "核销公式编码不能为空");
        Assert.notEmpty(calculateDto.getCustomerCodeList(), "客户编码不能为空");
        Assert.hasText(calculateDto.getBusinessUnitCode(), "业务单元不能为空");
        Assert.hasText(calculateDto.getBusinessFormatCode(), "业态不能为空");
        //查询非包含配置
        ConVariableDetailDto detailDto = new ConVariableDetailDto();
        detailDto.setAuditFormulaCode(auditFormulaCode);
        detailDto.setVariableCode(variableCode);
        List<ConVariableDetailVo> itemDetail = this.conVariableDetailRepository.getItemDetail(detailDto);
        SalesGoalDto salesGoalDto = new SalesGoalDto();
        salesGoalDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        salesGoalDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesGoalDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        Date startTimeOrDate = null;
        Date endTimeOrDate = null;
        if (!CollectionUtils.isEmpty(itemDetail)) {
            List<ConVariableDetailVo> filterList = itemDetail.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterList)) {
                ConVariableDetailVo variableDetailVo = itemDetail.get(0);
                startTimeOrDate = variableDetailVo.getBeginTime();
                endTimeOrDate = variableDetailVo.getEndTime();
            }
            salesGoalDto.setIncludeProductCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.INCLUDE_GOODS));
            salesGoalDto.setExcludeProductCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.GOODS));
            salesGoalDto.setExcludeProductItemCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.ITEM));
            salesGoalDto.setExcludeProductCategoryCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.CATEGORY));
            salesGoalDto.setExcludeProductBrandCodeList(this.getExcludeList(itemDetail, ConItemTypeEnum.BRAND));
        }
        if (CollectionUtils.isEmpty(salesGoalDto.getIncludeProductCodeList())) {
            if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
                salesGoalDto.setIncludeProductCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
            } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
                salesGoalDto.setProductItemCode(calculateDto.getItemCode());
            } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
                salesGoalDto.setProductCategoryCode(calculateDto.getCategoryCode());
            } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode()) && !StringUtils.equals(VariableCommonConstants.allBrandCode, calculateDto.getBrandCode())) {
                salesGoalDto.setProductBrandCode(calculateDto.getBrandCode());
            } else if (StringUtils.isEmpty(calculateDto.getBrandCode())) {
                throw new RuntimeException("产品和产品层级全部为空！");
            }
        }
        if (Objects.isNull(startTimeOrDate) && Objects.isNull(endTimeOrDate)) {
            Assert.notNull(calculateDto.getStartTimeOrDate(), "活动开始时间不能为空");
            Assert.notNull(calculateDto.getEndTimeOrDate(), "活动结束时间不能为空");
            startTimeOrDate = calculateDto.getStartTimeOrDate();
            endTimeOrDate = calculateDto.getEndTimeOrDate();
        }
        List<String> yearMonths = DateUtil.getBetweenYearMonths(startTimeOrDate, endTimeOrDate, DateUtil.DEFAULT_YEAR_MONTH);
        salesGoalDto.setYearMonthLySet(Sets.newHashSet(yearMonths));
        return salesGoalService.listForVariableCal(salesGoalDto);
    }

    private List<String> getExcludeList(List<ConVariableDetailVo> itemDetail, ConItemTypeEnum typeEnum) {
        return itemDetail.stream()
                .filter(e -> StringUtils.equals(typeEnum.getCode(), e.getItemType()) && StringUtils.isNotEmpty(e.getItemCode()))
                .map(ConVariableDetailVo::getItemCode).collect(Collectors.toList());
    }
}
