package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import static com.biz.crm.tpm.business.variable.local.register.ecommerce.PromotionPlanCommonService.GeneralExpensesEnum.ACTIVITY_ACTUAL_DAY;

/**
 * @className: ActivityActualDayRegister
 * @description: 活动实际天数
 * @author: hb
 * @create: 2023-02-23 20:20
 */
@Service
@Slf4j
public class ActivityActualDayRegister extends PromotionPlanCommonService implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "activityActualDay";
    }

    @Override
    public String getVariableName() {
        return "活动实际天数（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
//        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);
//        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        super.promotionPlanValidate(calculateDto);

        BigDecimal resultValue = super.getPromotionPlanValue(calculateDto, ACTIVITY_ACTUAL_DAY);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), resultValue);

        return resultMap;
    }
}
