package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: ActivityEndDateRegister
 * @description: 活动结束日期
 * @author: hb
 * @create: 2023-02-25 11:58
 */
@Service
@Slf4j
public class ActivityEndDateRegister extends PromotionPlanCommonService implements FormulaVariableRegister {


    @Override
    public String getVariableCode() {
        return "activityEndDate";
    }

    @Override
    public String getVariableName() {
        return "活动结束日期（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        super.promotionPlanValidate(calculateDto);

        BigDecimal resultValue = super.getPromotionPlanValue(calculateDto, GeneralExpensesEnum.ACTIVITY_END_DATE);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), resultValue);

        return resultMap;
    }
}
