package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import static com.biz.crm.tpm.business.variable.local.register.ecommerce.PromotionPlanCommonService.GeneralExpensesEnum.ACTIVITY_TOTAL_DAY;

/**
 * @className: TotalDayRegister
 * @description: 活动总天数
 * @author: hb
 * @create: 2023-02-24 9:58
 */
@Service
@Slf4j
public class ActivityTotalDayRegister extends PromotionPlanCommonService implements FormulaVariableRegister {

    @Autowired(required = false)
    private TpmWithholdingDetailService withholdingDetailService;

    @Override
    public String getVariableCode() {
        return "activityTotalDay";
    }

    @Override
    public String getVariableName() {
        return "活动总天数（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        super.promotionPlanValidate(calculateDto);

        BigDecimal resultValue = super.getPromotionPlanValue(calculateDto, ACTIVITY_TOTAL_DAY);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), resultValue);

        return resultMap;
    }
}
