package com.biz.crm.tpm.business.variable.local.register.ecommerce;


import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: BaseReturnPointMonthRegister
 * @description: 基础返点-月返
 * @author: hb
 * @create: 2023-02-24 14:51
 */
@Service
@Slf4j
public class BaseReturnPointMonthRegister extends DistribClosePolicyCommonService implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "baseReturnPointMonth";
    }

    @Override
    public String getVariableName() {
        return "基础返点-月返（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        super.paramVariable(calculateDto);
        log.info("基础返点-月返1:{}", JSONObject.toJSONString(calculateDto));
        BigDecimal resultValue = super.getDistributionClosurePolicy(calculateDto
                , DistributionClosePolicyActivityTypeEnum.Basic_Rebate_Monthly_Return.getKey());
        log.info("基础返点-月返2:{}",resultValue);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), resultValue);

        return resultMap;
    }
}
