package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.PutCostManageService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: CoinShakingRegister
 * @description: 抖币
 * @author: hb
 * @create: 2023-02-28 10:31
 */
@Slf4j
@Service
public class CoinShakingRegister extends PutCostManageService implements FormulaVariableRegister {


    private static final String REGISTER_KEY = "coin_shaking";

    @Override
    public String getVariableCode() {
        return "coinShaking";
    }

    @Override
    public String getVariableName() {
        return "抖币（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        super.platformDeliveryFeesValidate(calculateDto);

        BigDecimal coinShakingAmount = this.getPutCostAmount(calculateDto);
        
        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), coinShakingAmount);

        return resultMap;

    }
}
