package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: ContractAmountRegister
 * @description: 合同金额
 * @author: hb
 * @create: 2023-02-28 16:52
 */
@Service
public class ContractAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private GeneralExpensesService generalExpensesService;

    @Override
    public String getVariableCode() {
        return "contractAmount";
    }

    @Override
    public String getVariableName() {
        return "合同金额（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();

        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;

    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        Validate.notNull(calculateDto.getPromotionPlanCode(), "促销规划编码不能为空");

        BigDecimal contractAmount = generalExpensesService.getContractAmount(calculateDto.getPromotionPlanCode());

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), contractAmount);

        return resultMap;
    }
}
