package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @className: CostPlacementRegister
 * @description: 投放费用
 * @author: hb
 * @create: 2023-02-24 15:28
 */
@Service
@Slf4j
public class CostPlacementRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private TpmDistribClosePolicyService distribClosePolicyService;


    @Override
    public String getVariableCode() {
        return "eCommerceCostPlacement";
    }

    @Override
    public String getVariableName() {
        return "投放费用（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        Validate.notNull(calculateDto.getProductCode(), "产品编码不能为空");
        Validate.notNull(calculateDto.getDate(), "时间不能为空");
        Validate.notNull(calculateDto.getCustomerCode(), "客户编码不能为空");
        Validate.notNull(calculateDto.getEstoreCustomerLevel(), "电商客户等级编码不能为空");

        log.info("投放费用1:{}", JSONObject.toJSONString(calculateDto));

        SimpleDateFormat format = DateUtil.date_yyyy_MM_dd;

        TpmDistribClosePolicyDto distribClosePolicy = new TpmDistribClosePolicyDto();
        distribClosePolicy.setStartDate(format.format(calculateDto.getDate()));
        distribClosePolicy.setCustomerCode(calculateDto.getCustomerCode());
        distribClosePolicy.setProductCode(calculateDto.getProductCode());
        distribClosePolicy.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        BigDecimal resultDecimal = BigDecimal.ZERO;
        log.info("投放费用2:{}", JSONObject.toJSONString(distribClosePolicy));

        List<TpmDistribClosePolicyVo> list = this.distribClosePolicyService.findDistribClosePolicy(distribClosePolicy);
        if (CollectionUtils.isEmpty(list)){
            distribClosePolicy.setCustomerCode("");
            distribClosePolicy.setEstoreCustomerLevel(calculateDto.getEstoreCustomerLevel());
            log.info("投放费用3:{}", JSONObject.toJSONString(distribClosePolicy));
            list = this.distribClosePolicyService.findDistribClosePolicy(distribClosePolicy);
        }
        if (!CollectionUtils.isEmpty(list)){
            resultDecimal = list.get(0).getCostOfPlacement();
            log.info("投放费用4:{}", resultDecimal);
        }
        if (Objects.isNull(resultDecimal)) {
            resultDecimal = BigDecimal.ZERO;
        }
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), resultDecimal);

        return resultMap;
    }
}
