package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import cn.hutool.json.JSONUtil;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.service.Ce1MnjtSdkService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;

/**
 * @className: DailySalesDataService
 * @description: 电商日销售数据公共
 * @author: hb
 * @create: 2023-03-15 14:37
 */
@Slf4j
@Service
public abstract class DailySalesDataService {

    @Autowired(required = false)
    private Ce1MnjtSdkService ce1MnjtSdkService;

    public void dailySalesDataVariable(CalculateDto calculate){

        log.info("电商日销售数据指标请求参数:{}", JSONUtil.toJsonStr(calculate));

        Validate.notBlank(calculate.getCustomerCode(), "客户编码不能为空!");
        Validate.notBlank(calculate.getCustomerErpCode(),"客户MDG编码不能为空");
        Validate.notBlank(calculate.getSalesOrganizationCode(), "销售机构不能为空");
        Validate.notBlank(calculate.getBusinessFormatCode(), "业态不能为空");
        Validate.notBlank(calculate.getChannel(), "渠道不能为空");
        Validate.notBlank(calculate.getYearMonthLy(), "活动年月不能为空");

    }

    public BigDecimal getDailySalesDataValue(CalculateDto calculate, DailySalesValueEnum dailySalesValueEnum){

        Ce1MnjtFullDto ce1MnjtFull = new Ce1MnjtFullDto();

        ce1MnjtFull.setCustomerCode(calculate.getCustomerErpCode());
        ce1MnjtFull.setSaleOrgCode(calculate.getSalesOrgErpCode());
        ce1MnjtFull.setProductTeamCode(calculate.getBusinessFormatCode());
        ce1MnjtFull.setDistributionChannelCode(calculate.getChannel());
        ce1MnjtFull.setProductCode(calculate.getProductCode());

        String yearMonthLy = calculate.getYearMonthLy();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        String format1 = "";
        try {
            format1 = format.format(format.parse(yearMonthLy));
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
        format1 = format1.replaceAll("-", "");
        switch (dailySalesValueEnum){
            case EARLY:
                ce1MnjtFull.setActivityBeginTime(format1 + "01");
                ce1MnjtFull.setActivityEndTime(format1 + "10");
                break;
            case MID_HALF:
                ce1MnjtFull.setActivityBeginTime(format1 +"11");
                ce1MnjtFull.setActivityEndTime(format1 + "20");
                break;
            default:
        }

        BigDecimal salesIncludingTaxNetTotal = ce1MnjtSdkService.getSalesIncludingTaxNetTotal(ce1MnjtFull);

        return salesIncludingTaxNetTotal != null
                ? salesIncludingTaxNetTotal
                : BigDecimal.ZERO;
    }

    public enum DailySalesValueEnum{

        EARLY("early","上旬"),

        MID_HALF("mid-half","中旬");
        @Getter
        private String key;

        @Getter
        private String value;

        DailySalesValueEnum(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public DailySalesValueEnum getDailySales(String key){

            DailySalesValueEnum[] values = DailySalesValueEnum.values();

            for (DailySalesValueEnum value : values) {
                if (StringUtils.equals(value.getKey(), key)) {
                    return value;
                }
            }
            return null;
        }

    }

}
