package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.PutCostManageService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: DirectThrowRegister
 * @description: 直投
 * @author: hb
 * @create: 2023-02-28 14:17
 */
@Service
public class DirectThrowRegister extends PutCostManageService implements FormulaVariableRegister {

    private static final String REGISTER_KEY = "direct_throw";

    @Override
    public String getVariableCode() {
        return "directThrow";
    }

    @Override
    public String getVariableName() {
        return "直投（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        super.platformDeliveryFeesValidate(calculateDto);

        BigDecimal directThrowAmount = this.getPutCostAmount(calculateDto);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), directThrowAmount);

        return resultMap;
    }
}
