package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: DistributionMonthlyRejectVolumeRegister
 * @description: 分销月度剔量数量
 * @author: hb
 * @create: 2023-03-16 10:52
 */
@Slf4j
@Service
public class DistributionMonthlyRejectVolumeRegister extends MonthlySalesDistributionCommonService implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "distributionMonthlyRejectVolume";
    }

    @Override
    public String getVariableName() {
        return "分销月度剔量数量（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();

        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        MonthlySalesDistributionAmountEnum cullingNumber = MonthlySalesDistributionAmountEnum.CULLING_NUMBER;

        super.monthlySalesDistributionVariable(calculateDto, cullingNumber);

        BigDecimal resultValue = super.getMonthlySalesDistributionValue(calculateDto, cullingNumber);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), resultValue);

        return resultMap;
    }
}
