package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: DistributorMonthlyBasisSalesRegister
 * @description: 分销商月度基础销售金额
 * @date: 2023/2/20 20:08.
 * @author: hb
 */
@Service
@Slf4j
public class DistributorMonthBasisSalesRegister extends MonthlySalesDistributionCommonService implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "distributorMonthlyBasisSales";
    }

    @Override
    public String getVariableName() {
        return "分销商月度基础销售金额（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        MonthlySalesDistributionAmountEnum basicSalesAmount = MonthlySalesDistributionAmountEnum.BASIC_SALES_AMOUNT;

        super.monthlySalesDistributionVariable(calculateDto, basicSalesAmount);

        BigDecimal resultValue = super.getMonthlySalesDistributionValue(calculateDto, basicSalesAmount);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), resultValue);

        return resultMap;
    }
}
