package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import cn.hutool.core.util.ObjectUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.variable.local.utils.DateUtils;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @className: ECommerceAuditDateRegister
 * @description: 核销日期
 * @date: 2023/2/21 9:39.
 * @author: hb
 */
@Service
@Slf4j
public class ECommerceAuditDateRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private DetailedForecastService detailedForecastService;

    @Override
    public String getVariableCode() {
        return "eCommerceAuditDate";
    }

    @Override
    public String getVariableName() {
        return "核销日期（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

//        Validate.notBlank(calculateDto.getDetailPlanItemCode(), "细案明细编码不能为空");
//
//        DetailedForecastDto detailedForecast = new DetailedForecastDto();
//        detailedForecast.setActivityDetailItemCode(calculateDto.getDetailPlanItemCode());
//
//        DetailedForecastVo detailedForecastVo = detailedForecastService.getDetailedForecastByParams(detailedForecast);
        //2023-04-20 改成当前日期，取号数
        int dayOfMonth = DateUtil.getDayOfMonth(new Date());
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), new BigDecimal(dayOfMonth));
//        if (Objects.isNull(detailedForecastVo)) {
//            return resultMap;
//        }
//
//        Date createTime = detailedForecastVo.getCreateTime();
//        if (Objects.nonNull(detailedForecastVo.getModifyTime())) {
//            createTime = detailedForecastVo.getModifyTime();
//        }
//        LocalDateTime localDateTime = DateUtils.date2LocalDateTime(createTime);
//        int resultDay = ObjectUtil.isNull(localDateTime) ? 0 : localDateTime.getDayOfMonth();
//
//        resultMap.put(this.getVariableCode(), new BigDecimal(resultDay));

        return resultMap;
    }
}
