package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.PutCostManageService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: ThroughTrainRegister
 * @description: 电商 平台投放费用直通车
 * @date: 2023/2/21 14:28.
 * @author: hb
 */
@Service
@Slf4j
public class ECommerceThroughTrainRegister extends PutCostManageService implements FormulaVariableRegister {

    private static final String ACTIVITY_TYPE_KEY = "through_train";
    @Override
    public String getVariableCode() {
        return "throughTrain";
    }

    @Override
    public String getVariableName() {
        return "平台投放费用直通车（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.WITHHOLDING);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        super.platformDeliveryFeesValidate(calculateDto);

        BigDecimal putCostAmount = super.getPutCostAmount(calculateDto);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), putCostAmount);

        return resultMap;
    }
}
