package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: ECommonMonthlyTargetRegister
 * @description: 月度目标返
 * @author: hb
 * @create: 2023-03-15 13:58
 */
@Service
@Slf4j
public class ECommonMonthlyTargetRegister extends DistribClosePolicyCommonService implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "monthlyTarget";
    }

    @Override
    public String getVariableName() {
        return "月度目标返（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        super.paramVariable(calculateDto);
        log.info("月度目标返1:{}", JSONObject.toJSONString(calculateDto));
        BigDecimal resultValue = super.getDistributionClosurePolicy(calculateDto
                , DistributionClosePolicyActivityTypeEnum.MONTHLY_GOAL_RETURN.getKey());
        log.info("月度目标返2:{}", resultValue);
        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), resultValue);

        return resultMap;
    }
}
