package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.settlement.manage.sdk.dto.TpmSettlementManageDto;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

@Component
public class EcommerceRegisterHelper {

    public TpmSettlementManageDto buildTpmSettlementManageDto(CalculateDto calculateDto){
        Validate.notNull(calculateDto.getCustomerCode(),"客户编码不能为空");
        Validate.notNull(calculateDto.getActivityFormCode(),"活动形式不能为空");
        Validate.notNull(calculateDto.getStartTimeOrDate(),"活动开始时间不能为空");
        Validate.notNull(calculateDto.getEndTimeOrDate(),"活动结束时间不能为空");
        TpmSettlementManageDto dto = new TpmSettlementManageDto();
        dto.setCustomerCode(calculateDto.getCustomerCode());
        dto.setActivityFormCode(calculateDto.getActivityFormCode());
        dto.setBusinessStartTime(calculateDto.getStartTimeOrDate());
        dto.setBusinessEndTime(calculateDto.getEndTimeOrDate());
        return dto;
    }
}
