package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.PutCostManageService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: GreatQuantityThousandRiversRegister
 * @description: 巨量千川
 * @author: hb
 * @create: 2023-02-28 13:56
 */
@Service
public class GreatQuantityThousandRiversRegister extends PutCostManageService implements FormulaVariableRegister {

    private static final String REGISTER_KEY = "great_quantity_thousand_rivers";

    @Override
    public String getVariableCode() {
        return "greatQuantityThousandRivers";
    }

    @Override
    public String getVariableName() {
        return "巨量千川（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;

    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        this.getPutCostAmount(calculateDto);
        return null;
    }
}
