package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: BundlingReturnPointRegister
 * @description: 上月组合装返点
 * @author: hb
 * @create: 2023-02-24 15:36
 */

@Service
@Slf4j
public class LastBundlingReturnPointRegister extends DistribClosePolicyCommonService implements FormulaVariableRegister {


    @Override
    public String getVariableCode() {
        return "lastBundlingReturnPoint";
    }

    @Override
    public String getVariableName() {
        return "上月组合装返点（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;

    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        super.paramVariable(calculateDto);
        log.info("上月组合装返点1:{}", JSONObject.toJSONString(calculateDto));
        BigDecimal resultValue = super.getDistributionClosurePolicy(calculateDto
                , DistributionClosePolicyActivityTypeEnum.LAST_BUNDLE_REBATES.getKey());
        log.info("上月组合装返点2:{}", JSONObject.toJSONString(resultValue));
        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), resultValue);

        return resultMap;
    }
}
