package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

/**
 * @className: MonthlyTargetRegister
 * @description: 月度目标
 * @author: hb
 * @create: 2023-02-24 15:01
 */
public class MonthlyReturnTargetRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private TpmDistribClosePolicyService distribClosePolicyService;


    @Override
    public String getVariableCode() {
        return "monthlyReturnTarget";
    }

    @Override
    public String getVariableName() {
        return "月度目标（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        Validate.notNull(calculateDto.getProductCode(), "产品编码不能为空");
        Validate.notNull(calculateDto.getDate(), "时间不能为空");
        Validate.notNull(calculateDto.getCustomerCode(), "客户编码不能为空");
        Validate.notNull(calculateDto.getEstoreCustomerLevel(), "电商客户等级编码不能为空");


        SimpleDateFormat format = DateUtil.date_yyyy_MM_dd;

        TpmDistribClosePolicyDto distribClosePolicy = new TpmDistribClosePolicyDto();
        distribClosePolicy.setStartDate(format.format(calculateDto.getDate()));
        distribClosePolicy.setCustomerCode(calculateDto.getCustomerCode());
        BigDecimal resultDecimal = BigDecimal.ZERO;
        List<TpmDistribClosePolicyVo> list = this.distribClosePolicyService.findDistribClosePolicy(distribClosePolicy);
        if (CollectionUtils.isEmpty(list)){
            distribClosePolicy.setCustomerCode("");
            distribClosePolicy.setEstoreCustomerLevel(calculateDto.getEstoreCustomerLevel());
            list = this.distribClosePolicyService.findDistribClosePolicy(distribClosePolicy);
        }
        if (!CollectionUtils.isEmpty(list)){
            resultDecimal = list.get(0).getMonthlyTargetReturn();
        }

        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), resultDecimal);

        return resultMap;
    }
}
