package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import cn.hutool.core.util.ObjectUtil;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.biz.crm.tpm.business.variable.local.utils.BigDecimalUtils;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @className: MonthlySalesDistributionCommonService
 * @description: 分销客户月度销售公共类
 * @author: hb
 * @create: 2023-03-16 9:20
 */
@Slf4j
@Service
public abstract class MonthlySalesDistributionCommonService {

    @Autowired(required = false)
    private TpmDistributionCustomerMonthSaleService distributionCustomerMonthSaleService;

    /**
     * 参数验证
     * @param calculate 参数
     */
    public void monthlySalesDistributionVariable(CalculateDto calculate, MonthlySalesDistributionAmountEnum monthlySalesDistributionAmountEnum){

        Validate.notBlank(calculate.getCustomerCode(), "客户编码不能为空!");
        Validate.notBlank(calculate.getCustomerErpCode(), "客户MDG编码不能为空!");
        Validate.notBlank(calculate.getSalesOrganizationCode(), "销售机构编码不能为空!");
        Validate.notBlank(calculate.getBusinessFormatCode(), "业态不能为空!");
        Validate.notBlank(calculate.getChannel(), "渠道不能为空!");
        if (!StringUtils.equals(MonthlySalesDistributionAmountEnum.TOTAL_AMOUNT_MONTH.getKey(), monthlySalesDistributionAmountEnum.getKey())){
            Validate.notBlank(calculate.getProductCode(), "产品不能为空!");
        }
        if (StringUtils.equals(MonthlySalesDistributionAmountEnum.TOTAL_AMOUNT_YEAR.getKey(), monthlySalesDistributionAmountEnum.getKey())){
            Validate.notBlank(calculate.getYearLy(), "活动年不能为空");
        }else {
            Validate.notBlank(calculate.getYearMonthLy(), "活动年月不能为空!");
        }

    }

    public BigDecimal getMonthlySalesDistributionValue(CalculateDto calculate, MonthlySalesDistributionAmountEnum monthlySalesDistributionAmountEnum){

        BigDecimal resultValue = BigDecimal.ZERO;

        TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale = new TpmDistributionCustomerMonthSaleDto();
        //TODO 客户编码待改动
        distributionCustomerMonthSale.setCustomerCode(calculate.getCustomerErpCode());
        distributionCustomerMonthSale.setChannelCode(calculate.getChannel());
        distributionCustomerMonthSale.setBusinessFormatCode(calculate.getBusinessFormatCode());
        int length = calculate.getSalesOrganizationCode().length();
        distributionCustomerMonthSale.setSalesInstitutionCode(calculate.getSalesOrganizationCode().substring(length-4, length));

        if (StringUtils.equals(MonthlySalesDistributionAmountEnum.TOTAL_AMOUNT_YEAR.getKey(), monthlySalesDistributionAmountEnum.getKey())){
            distributionCustomerMonthSale.setDistributionCustomerMonthSaleYearMonth(calculate.getYearLy());
        }else {
            distributionCustomerMonthSale.setDistributionCustomerMonthSaleYearMonth(calculate.getYearMonthLy());
        }
        if (!StringUtils.equals(MonthlySalesDistributionAmountEnum.TOTAL_AMOUNT_MONTH.getKey(), monthlySalesDistributionAmountEnum.getKey())){
            distributionCustomerMonthSale.setProductCode(calculate.getProductCode());
        }

        List<TpmDistributionCustomerMonthSaleRespVo> list = distributionCustomerMonthSaleService.findCustomerMonthSalesByParams(distributionCustomerMonthSale);

        if (CollectionUtils.isEmpty(list)){
            return resultValue;
        }

        if (StringUtils.equals(MonthlySalesDistributionAmountEnum.TOTAL_AMOUNT_YEAR.getKey(), monthlySalesDistributionAmountEnum.getKey())){
            resultValue = list.stream()
                    .filter(customerMonthSale ->
                            ObjectUtil.isNotNull(customerMonthSale.getMonthSaleAmount()))
                    .map(TpmDistributionCustomerMonthSaleRespVo::getMonthSaleAmount)
                    .collect(Collectors.toList())
                    .stream()
                    .reduce(BigDecimal.ZERO, BigDecimalUtils::sum);
        }else {
            //TpmDistributionCustomerMonthSaleRespVo distributionCustomerMonthSaleResp = list.get(0);
            switch (monthlySalesDistributionAmountEnum){
                case BASIC_SALES_AMOUNT:
                    resultValue = list.stream()
                            .filter(customerMonthSale ->
                                    ObjectUtil.isNotNull(customerMonthSale.getBasicSaleAmount()))
                            .map(TpmDistributionCustomerMonthSaleRespVo::getBasicSaleAmount)
                            .collect(Collectors.toList())
                            .stream()
                            .reduce(BigDecimal.ZERO, BigDecimalUtils::sum);
                    break;
                case BIND_SALES_AMOUNT:
                    resultValue = list.stream()
                            .filter(customerMonthSale ->
                                    ObjectUtil.isNotNull(customerMonthSale.getBoundGiftSaleAmount()))
                            .map(TpmDistributionCustomerMonthSaleRespVo::getBoundGiftSaleAmount)
                            .collect(Collectors.toList())
                            .stream()
                            .reduce(BigDecimal.ZERO, BigDecimalUtils::sum);
                    break;
                case TOTAL_AMOUNT_MONTH:
                    resultValue = list.stream()
                            .filter(customerMonthSale ->
                                    ObjectUtil.isNotNull(customerMonthSale.getMonthSaleAmount()))
                            .map(TpmDistributionCustomerMonthSaleRespVo::getMonthSaleAmount)
                            .collect(Collectors.toList())
                            .stream()
                            .reduce(BigDecimal.ZERO, BigDecimalUtils::sum);
                    break;
                case AMOUNT_MONTH:
                    resultValue = list.stream()
                            .filter(customerMonthSale ->
                                    ObjectUtil.isNotNull(customerMonthSale.getMonthSaleAmount()))
                            .map(TpmDistributionCustomerMonthSaleRespVo::getMonthSaleAmount)
                            .collect(Collectors.toList())
                            .stream()
                            .reduce(BigDecimal.ZERO, BigDecimalUtils::sum);
                    break;
                case CULLING_AMOUNT:
                    resultValue = list.stream()
                            .filter(customerMonthSale ->
                                    ObjectUtil.isNotNull(customerMonthSale.getRidSaleAmount()))
                            .map(TpmDistributionCustomerMonthSaleRespVo::getRidSaleAmount)
                            .collect(Collectors.toList())
                            .stream()
                            .reduce(BigDecimal.ZERO, BigDecimalUtils::sum);
                    break;
                case CULLING_NUMBER:
                    resultValue = list.stream()
                            .filter(customerMonthSale ->
                                    ObjectUtil.isNotNull(customerMonthSale.getRidSaleQuantity()))
                            .map(TpmDistributionCustomerMonthSaleRespVo::getRidSaleQuantity)
                            .collect(Collectors.toList())
                            .stream()
                            .reduce(BigDecimal.ZERO, BigDecimalUtils::sum);
                    break;
                default:
            }
        }

        return resultValue;
    }

    public enum MonthlySalesDistributionAmountEnum{

        BASIC_SALES_AMOUNT("basic_sales_amount", "基础销售金额"),

        BIND_SALES_AMOUNT("bind_sales_amount", "捆赠销售金额"),

        TOTAL_AMOUNT_MONTH("total_amount_month", "累计总销售金额"),

        AMOUNT_MONTH("amount_month", "总销售金额"),

        TOTAL_AMOUNT_YEAR("total_amount_year", "累计销售金额整年"),

        CULLING_AMOUNT("culling_amount","剔量金额"),

        CULLING_NUMBER("culling_number", "剔量数量");

        @Getter
        private String key;
        @Getter
        private String desc;

        MonthlySalesDistributionAmountEnum(String key, String desc) {
            this.key = key;
            this.desc = desc;
        }

        public MonthlySalesDistributionAmountEnum getMonthlySalesDistributionByKey(String key){

            MonthlySalesDistributionAmountEnum[] values = MonthlySalesDistributionAmountEnum.values();

            for (MonthlySalesDistributionAmountEnum value : values) {

                if (StringUtils.equals(value.getKey(), key)) {
                    return value;
                }
            }

            return null;
        }
    }
}
