package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: PersonnelCostRegister
 * @description: 人员费用
 * @author: hb
 * @create: 2023-02-24 15:26
 */
@Service
@Slf4j
public class PersonnelCostRegister extends DistribClosePolicyCommonService implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "personnelCost";
    }

    @Override
    public String getVariableName() {
        return "人员费用（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        super.paramVariable(calculateDto);
        log.info("人员费用1:{}", JSONObject.toJSONString(calculateDto));
        BigDecimal resultValue = super.getDistributionClosurePolicy(calculateDto
                , DistributionClosePolicyActivityTypeEnum.PERSONNEL_COSTS.getKey());
        log.info("人员费用2:{}", resultValue);
        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), resultValue);

        return resultMap;
    }
}
