package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

/**
 * @className: PlatformMonthlySalesRegister
 * @description: 平台月度销售
 * @author: hb
 * @create: 2023-02-24 10:12
 */
@Slf4j
@Service
public class PlatformMonthlySalesRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private TpmDaySalesService daySalesService;

    @Override
    public String getVariableCode() {
        return "platformMonthlySales";
    }

    @Override
    public String getVariableName() {
        return "平台月度销售（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        Validate.notNull(calculateDto.getCustomerCode(), "客户编码不能为空");
        Validate.notNull(calculateDto.getStartTimeOrDate(), "开始时间不能为空");
        Validate.notNull(calculateDto.getEndTimeOrDate(), "结束时间不能为空");

        TpmDaySalesSearchDto daySalesSearch = new TpmDaySalesSpliceSearchDto();
        daySalesSearch.setCustomer(calculateDto.getCustomerCode());

        SimpleDateFormat format = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        try {
            daySalesSearch.setStartDate(format.parse(format.format(calculateDto.getStartTimeOrDate())));
            daySalesSearch.setEndDate(format.parse(format.format(calculateDto.getEndTimeOrDate())));
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }

        BigDecimal daySalesTotalAmount = daySalesService.getDaySalesTotalAmount(daySalesSearch);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), daySalesTotalAmount);

        return resultMap;
    }
}
