package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.settlement.manage.sdk.dto.TpmSettlementManageDto;
import com.biz.crm.tpm.business.settlement.manage.sdk.service.TpmSettlementManageService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 自播佣金
 */
@Service
@Slf4j
public class SelfScreeningKickbackRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private EcommerceRegisterHelper ecommerceRegisterHelper;

    @Autowired(required = false)
    private TpmSettlementManageService tpmSettlementManageService;

    @Override
    public String getVariableCode() {
        return "selfScreeningKickback";
    }

    @Override
    public String getVariableName() {
        return "自播佣金（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        TpmSettlementManageDto dto = ecommerceRegisterHelper.buildTpmSettlementManageDto(calculateDto);
        BigDecimal amount = tpmSettlementManageService.getAmountByActivityFormCode(dto);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), amount);
        return resultMap;
    }
}
