package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.settlement.manage.sdk.dto.TpmSettlementManageDto;
import com.biz.crm.tpm.business.settlement.manage.sdk.service.TpmSettlementManageService;
import com.biz.crm.tpm.business.variable.local.utils.DateUtils;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;

/**
 * @className: SettlementManageCommonService
 * @description: 平台结算单管理公共类
 * @author: hb
 * @create: 2023-03-17 20:34
 */
@Slf4j
@Service
public abstract class SettlementManageCommonService {

    @Autowired(required = false)
    private TpmSettlementManageService settlementManageService;

    public void  settlementManageValidate(CalculateDto calculate){

        Validate.notBlank(calculate.getCustomerErpCode(), "客户MGB编码不能为空");
        Validate.notBlank(calculate.getSalesOrganizationCode(), "销售机构不能为空");
        Validate.notBlank(calculate.getBusinessFormatCode(), "业态不能为空");
        Validate.notBlank(calculate.getChannel(), "渠道编码不能为空");
        Validate.notBlank(calculate.getYearMonthLy(), "活动年月不能为空");
        Validate.notBlank(calculate.getActivityFormCode(), "活动形式编码不能为空");

    }

    public BigDecimal getSettlementManageValue(CalculateDto calculate){
        //客户编码拼接
        String customerCode = calculate.getCustomerErpCode() +
                calculate.getSalesOrganizationCode() +
                calculate.getChannel() +
                calculate.getBusinessFormatCode();

        TpmSettlementManageDto settlementManage = new TpmSettlementManageDto();

        settlementManage.setCustomerCode(customerCode);
        settlementManage.setProductCode(calculate.getProductCode());
        settlementManage.setActivityFormCode(calculate.getActivityFormCode());

        String yearMonthLy = calculate.getYearMonthLy();
        boolean flag = yearMonthLy.contains("-");
        String strYearMonthLy = "";
        if (flag){
           strYearMonthLy = yearMonthLy.substring(0, 4) + yearMonthLy.substring(6);
        }else {
            strYearMonthLy = yearMonthLy;
        }

        LocalDate date = LocalDate.parse(strYearMonthLy + "01", DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate dateFirst = date.with(TemporalAdjusters.firstDayOfMonth()); // 指定年月的第一天
        LocalDate dateEnd = date.with(TemporalAdjusters.lastDayOfMonth()); // 指定年月的最后一天
        settlementManage.setBusinessStartTime(DateUtils.localDate2Date(dateFirst));
        settlementManage.setBusinessEndTime(DateUtils.localDate2Date(dateEnd));

        return settlementManageService.getAmount(settlementManage);

    }

}
