package com.biz.crm.tpm.business.variable.local.register.ecommerce;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: TotalAnnualSalesYearAmountDistributorRegister
 * @description: 分销商年度销售总金额
 * @author: hb
 * @create: 2023-02-23 19:22
 */
@Service
@Slf4j
public class TotalAnnualSalesYearAmountDistributorRegister extends MonthlySalesDistributionCommonService implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "totalAnnualSalesYearAmountDistributor";
    }

    @Override
    public String getVariableName() {
        return "分销商年度销售总金额（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        MonthlySalesDistributionAmountEnum totalAmountYear = MonthlySalesDistributionAmountEnum.TOTAL_AMOUNT_YEAR;
        if (StringUtils.isNotEmpty(calculateDto.getYearMonthLy()) && StringUtils.isEmpty(calculateDto.getYearLy())) {
            calculateDto.setYearLy(calculateDto.getYearMonthLy().substring(0, 4));
        }
        super.monthlySalesDistributionVariable(calculateDto, totalAmountYear);

        BigDecimal resultValue = super.getMonthlySalesDistributionValue(calculateDto, totalAmountYear);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), resultValue);

        return resultMap;
    }
}
