package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.variable.local.register.estore.common.TpmDistributionCustomerSalesDataHelper;
import com.biz.crm.tpm.business.variable.local.register.estore.common.TpmDistributionCustomerSalesDataPropertyConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 月度总销量
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-15
 */
@Slf4j
@Service
public class ECombinationSalesQuantityRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private TpmDistributionCustomerSalesDataHelper tpmDistributionCustomerSalesDataHelper;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "eCombinationSalesQuantity";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "组合装销售数量（电商）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        tpmDistributionCustomerSalesDataHelper.val(calculateDto);
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(),
                tpmDistributionCustomerSalesDataHelper.getValue(calculateDto, TpmDistributionCustomerSalesDataPropertyConstants.BOUND_GIFT_SALE_QUANTITY, TpmDistributionCustomerSalesDataHelper.MONTH));
        return resultMap;
    }
}
