package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.variable.local.register.estore.common.TpmDistributionLaunchCostsDataHelper;
import com.biz.crm.tpm.business.variable.local.register.estore.common.TpmDistributionLaunchCostsDataPropertyConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 政策投放总费用
 */
@Service
@Slf4j
public class EDistributionActualLaunchCostsTotalRegister extends TpmDistributionLaunchCostsDataHelper implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "eDistributionActualLaunchCostsTotal";
    }

    @Override
    public String getVariableName() {
        return "实际投放总费用（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        this.valParam(calculateDto);
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), this.getValue(calculateDto, TpmDistributionLaunchCostsDataPropertyConstants.actualTotalAmount));
        return resultMap;
    }
}
