package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.biz.crm.tpm.business.variable.local.register.estore.common.TpmDistributionLaunchCostsDataHelper;
import com.biz.crm.tpm.business.variable.local.register.estore.common.TpmDistributionLaunchCostsDataPropertyConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分销客户投放费用表
 */
@Service
@Slf4j
public class EDistributionCustomerLaunchCostsRegister extends TpmDistributionLaunchCostsDataHelper implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "eDistributionCustomerLaunchCosts";
    }

    @Override
    public String getVariableName() {
        return "分销客户投放费用表（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        this.valParam(calculateDto);
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), this.getValue(calculateDto, TpmDistributionLaunchCostsDataPropertyConstants.customerAmountProvided));
        return resultMap;
    }
}
