package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataImportDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.service.TpmDistributionCustomerAuditDataService;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo;
import com.biz.crm.tpm.business.variable.local.register.estore.common.TpmDistributionCustomerAuditDataHelper;
import com.biz.crm.tpm.business.variable.local.register.estore.common.TpmDistributionCustomerAuditDataPropertyConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 分销物流费用
 */
@Service
@Slf4j
public class EDistributionLogisticsAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private TpmDistributionCustomerAuditDataHelper tpmDistributionCustomerAuditDataHelper;
    @Override
    public String getVariableCode() {
        return "eDistributionLogisticsAmount";
    }

    @Override
    public String getVariableName() {
        return "分销物流费用（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        tpmDistributionCustomerAuditDataHelper.valParam(calculateDto);
        BigDecimal value = tpmDistributionCustomerAuditDataHelper.getValue(calculateDto, TpmDistributionCustomerAuditDataPropertyConstants.LOGISTIC_COST);
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), value);
        return resultMap;
    }
}
