package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.variable.local.register.estore.common.TpmDistributionCustomerAuditDataHelper;
import com.biz.crm.tpm.business.variable.local.register.estore.common.TpmDistributionCustomerAuditDataPropertyConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 分销物流客户销售数量
 */
@Service
@Slf4j
public class EDistributionLogisticsSaleQuantityRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private TpmDistributionCustomerAuditDataHelper tpmDistributionCustomerAuditDataHelper;
    @Override
    public String getVariableCode() {
        return "eDistributionLogisticsSaleQuantity";
    }

    @Override
    public String getVariableName() {
        return "分销物流客户销售数量（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        tpmDistributionCustomerAuditDataHelper.valParam(calculateDto);
        BigDecimal value = tpmDistributionCustomerAuditDataHelper.getValue(calculateDto, TpmDistributionCustomerAuditDataPropertyConstants.SALE_QUANTITY);
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), value);
        return resultMap;
    }
}
