package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分销人员政策总额
 */
@Service
@Slf4j
public class EDistributionPersonPolicyAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private TpmDistribClosePolicyService tpmDistribClosePolicyService;

    @Autowired(required = false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;
    @Override
    public String getVariableCode() {
        return "eDistributionPersonPolicyAmount";
    }

    @Override
    public String getVariableName() {
        return "分销人员政策总额（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerCode(), "客户编码不能为空");
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码不能为空");
        Validate.notBlank(calculateDto.getSalesOrganizationCode(), "销售机构不能为空");
        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notBlank(calculateDto.getChannel(), "渠道不能为空！");
        Validate.notBlank(calculateDto.getYearMonthLy(), "活动年月不能为空！");
        //Validate.notBlank(calculateDto.getProductCode(),"产品编码不能为空！");
        Validate.notBlank(calculateDto.getEstoreCustomerLevel(),"电商客户等级编码！");

        //查询分销客户月度销售表
        TpmDistributionCustomerMonthSaleDto dto = new TpmDistributionCustomerMonthSaleDto();
        dto.setCustomerCode(calculateDto.getCustomerErpCode());
        dto.setSalesInstitutionCode(calculateDto.getSalesOrganizationErpCode());
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setChannelCode(calculateDto.getChannel());
        dto.setDistributionCustomerMonthSaleYearMonth(calculateDto.getYearMonthLy());
        //dto.setProductCode(calculateDto.getProductCode());

        List<TpmDistributionCustomerMonthSaleRespVo> saleRespVos = tpmDistributionCustomerMonthSaleService.listForVariable(dto,"month");
        Map<String,List<TpmDistributionCustomerMonthSaleRespVo>> saleMap = saleRespVos.stream().collect(Collectors.groupingBy(TpmDistributionCustomerMonthSaleRespVo::getProductCode));
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Map.Entry<String,List<TpmDistributionCustomerMonthSaleRespVo>> entry : saleMap.entrySet()){
            String product = entry.getKey();
            List<TpmDistributionCustomerMonthSaleRespVo> list = entry.getValue();
            //查询分销结案政策
            TpmDistribClosePolicyDto policyDto = new TpmDistribClosePolicyDto();
            policyDto.setCustomerCode(calculateDto.getCustomerCode());
            policyDto.setProductCode(product);
            policyDto.setStartDate(calculateDto.getYearMonthLy()+"-01");
            List<TpmDistribClosePolicyVo> policyVos = tpmDistribClosePolicyService.findDistribClosePolicy(policyDto);
            //如果按照客户查询不到则按照等级查询
            if(CollectionUtils.isEmpty(policyVos)){
                policyDto.setEstoreCustomerLevel(calculateDto.getEstoreCustomerLevel());
                policyDto.setCustomerCode(null);
                policyVos = tpmDistribClosePolicyService.findDistribClosePolicy(policyDto);
            }
            BigDecimal staffCosts = BigDecimal.ZERO;
            if(!CollectionUtils.isEmpty(policyVos)){
                staffCosts = policyVos.get(0).getStaffCosts();
            }
            BigDecimal monthAmount = BigDecimal.ZERO;
            BigDecimal manualAuditSaleAmount = BigDecimal.ZERO;
            if(!CollectionUtils.isEmpty(saleRespVos)){
                monthAmount = list.stream()
                        .filter(e -> Objects.nonNull(e.getMonthSaleAmount()))
                        .map(TpmDistributionCustomerMonthSaleRespVo::getMonthSaleAmount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                manualAuditSaleAmount = list.stream()
                        .filter(e -> Objects.nonNull(e.getManualAuditSaleAmount()))
                        .map(TpmDistributionCustomerMonthSaleRespVo::getManualAuditSaleAmount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            BigDecimal amt = Optional.ofNullable(monthAmount).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(manualAuditSaleAmount).orElse(BigDecimal.ZERO));
            amt = amt.multiply(Optional.ofNullable(staffCosts).orElse(BigDecimal.ZERO));
            totalAmount = totalAmount.add(amt);
        }
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), totalAmount);
        return resultMap;
    }
}
