package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.distribution.wages.sdk.dto.DistributionWagesDto;
import com.biz.crm.tpm.business.distribution.wages.sdk.service.DistributionWagesService;
import com.biz.crm.tpm.business.distribution.wages.sdk.vo.DistributionWagesVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 分销人员工资总额
 */
@Service
@Slf4j
public class EDistributionPersonWagesAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private DistributionWagesService distributionWagesService;
    @Override
    public String getVariableCode() {
        return "eDistributionPersonWagesAmount";
    }

    @Override
    public String getVariableName() {
        return "分销人员工资总额（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
//        Validate.notBlank(calculateDto.getCustomerCode(), "客户编码不能为空!");
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码不能为空!");
        Validate.notBlank(calculateDto.getYearMonthLy(),"年月不能为空");

        DistributionWagesDto distributionWagesDto = new DistributionWagesDto();
        distributionWagesDto.setCustomerCode(calculateDto.getCustomerErpCode());
        distributionWagesDto.setYears(calculateDto.getYearMonthLy());
        List<DistributionWagesVo> voList = distributionWagesService.findForVariable(distributionWagesDto);
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        if(CollectionUtils.isEmpty(voList)){
            resultMap.put(this.getVariableCode(),BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(),
                voList.stream()
                        .filter(e -> Objects.nonNull(e.getSalaryAmount()))
                        .map(DistributionWagesVo::getSalaryAmount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add));
        return resultMap;
    }
}
