package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 本月已结案金额
 */
@Service
@Slf4j
public class EMonthAuditAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private AuditService auditService;
    @Override
    public String getVariableCode() {
        return "eMonthAuditAmount";
    }

    @Override
    public String getVariableName() {
        return "本月已结案金额（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerCode(), "客户编码不能为空!");
        Validate.notBlank(calculateDto.getProductCode(), "产品编码不能为空!");
        Validate.notBlank(calculateDto.getYearMonthLy(),"年月不能为空");
        AuditCustomerDetailCollectionDto dto = new AuditCustomerDetailCollectionDto();
        dto.setCustomerCode(calculateDto.getCustomerCode());
        dto.setProductCode(calculateDto.getProductCode());
        dto.setFeeYearMonth(DateUtil.parseDate(calculateDto.getYearMonthLy(),"yyyy-MM"));
        BigDecimal amount = auditService.findAuditAmountForVariable(dto);
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(),amount);
        return resultMap;
    }
}
