package com.biz.crm.tpm.business.variable.local.register.estore;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.tpm.business.variable.local.register.common.PriceRegisterParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @className: EPlatformSupplyPriceVariableRegister
 * @description: 平台供货价（元）(电商)
 * @author: hb
 * @create: 2023-02-28 19:53
 */
@Slf4j
@Service
public class EPlatformSupplyPriceVariableRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private PriceModelVoService priceModelVoService;


    @Override
    public String getVariableCode() {
        return "ePlatformSupplyPriceVariable";
    }

    @Override
    public String getVariableName() {
        return "平台供货价（元）（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();

        list.add(VariableFunctionEnum.AUDIT);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码为空！");
        Validate.notBlank(calculateDto.getProductCode(), "产品编码为空！");
        Validate.notBlank(calculateDto.getSalesOrgErpCode(), "销售组织短码为空！");
        Validate.notNull(calculateDto.getStartTimeOrDate(), "活动开始时间为空！");
        calculateDto.setSearchTime(calculateDto.getStartTimeOrDate());
        SearchPriceDto searchPrice = PriceRegisterParamBuilder.buildParam(calculateDto, PriceTypeEnum.ZDS1);
        log.info("========================================平台供货价（元）（电商）调用价格参数：" + JSONObject.toJSONString(searchPrice));
        Map<String, PriceModelVo> priceModelVoMap = priceModelVoService.handleSearchPrice(searchPrice);
        BigDecimal resultPrice = BigDecimal.ZERO;
        if (Objects.nonNull(priceModelVoMap)) {
            for (Map.Entry<String, PriceModelVo> entry : priceModelVoMap.entrySet()) {
                PriceModelVo value = entry.getValue();
                BigDecimal price = value.getPrice();
                if (!Objects.isNull(price)) {
                    resultPrice = price;
                    break;
                }
            }
        }
        log.info("========================================平台供货价（元）（电商）调用价格结果：" + JSONObject.toJSONString(priceModelVoMap));
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), resultPrice);
        return resultMap;
    }
}
