package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.variable.local.register.estore.common.TpmPlatformRebateOrderDataHelper;
import com.biz.crm.tpm.business.variable.local.register.estore.common.TpmPlatformRebateOrderDataPropertyConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-15
 */
@Slf4j
@Service
public class ESaleRebateCostRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private TpmPlatformRebateOrderDataHelper tpmPlatformRebateOrderDataHelper;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "eSaleRebateCost";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "销售返费用（电商）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        tpmPlatformRebateOrderDataHelper.valParam(calculateDto);
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(),
                tpmPlatformRebateOrderDataHelper.getValue(calculateDto, TpmPlatformRebateOrderDataPropertyConstants.saleRebateCost));
        return resultMap;
    }
}
