package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * <p>
 * 供货价
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-14
 */
@Slf4j
@Service
public class EStoreSupplyPriceRegister implements FormulaVariableRegister {

//    @Autowired(required = false)
//    private PriceModelVoService priceModelVoService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "eStoreSupplyPrice";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "供货价（电商）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.APPLY);
        return list;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
//        SearchPriceDto searchPrice = new SearchPriceDto();
//        searchPrice.setCustomerCode(calculateDto.getCustomerCode());
//        searchPrice.setSet(Sets.newHashSet(calculateDto.getProductCode()));
//
//        //默认电商平台供货价
//        searchPrice.setPriceTypeCode(PriceTypeEnum.PLATFORM_SUPPLY_PRICE.getDictCode());
//        Map<String, PriceModelVo> priceModelVoMap = priceModelVoService.handleSearchPrice(searchPrice);

        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
//        for (Map.Entry<String, PriceModelVo> entry : priceModelVoMap.entrySet()){
//            PriceModelVo value = entry.getValue();
//            BigDecimal platformSupplyPrice = value.getPlatformSupplyPrice();
//            if (!Objects.isNull(platformSupplyPrice)){
//                resultMap.put(this.getVariableCode(), platformSupplyPrice);
//                break;
//            }
//        }
        return resultMap;
    }
}
