package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-21
 */
@Service
@Slf4j
public class EYearSalesTargetRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "eYearSalesTarget";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "年度销售目标（电商）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        Validate.notBlank(calculateDto.getSalesOrganizationCode(), "销售机构为空");
        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态为空");
        Validate.notBlank(calculateDto.getChannel(), "渠道为空");
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码为空");
        Validate.notBlank(calculateDto.getYearMonthLy(), "年月为空");

        SalesGoalDto salesGoalDto = new SalesGoalDto();
        salesGoalDto.setSalesInstitutionCode(calculateDto.getSalesOrganizationCode());
        salesGoalDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesGoalDto.setChannelCode(calculateDto.getChannel());
        salesGoalDto.setCustomerErpCode(calculateDto.getCustomerErpCode());
        salesGoalDto.setYearMonthLy(calculateDto.getYearMonthLy());

        List<SalesGoalVo> vos = salesGoalService.listForVariableCalNew(salesGoalDto);

        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(vos)) {
            return resultMap;
        }
        BigDecimal total = vos.stream().filter(e -> Objects.nonNull(e.getDeliverySalesAmount())).map(SalesGoalVo::getDeliverySalesAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }
}
