package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularDto;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 考核通报金额
 */
@Service
@Slf4j
public class ExamineCircularAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private TpmExamineCircularService tpmExamineCircularService;
    @Override
    public String getVariableCode() {
        return "examineCircularAmount";
    }

    @Override
    public String getVariableName() {
        return "考核通报金额（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerCode(), "客户编码不能为空!");
        Validate.notBlank(calculateDto.getProductCode(), "产品编码不能为空!");
        Validate.notBlank(calculateDto.getYearMonthLy(),"年月不能为空");

        TpmExamineCircularDto dto = new TpmExamineCircularDto();
        dto.setCustomerCode(calculateDto.getCustomerCode());
        dto.setExamineCircularYearMonth(calculateDto.getYearMonthLy());
        BigDecimal amount = tpmExamineCircularService.findSplitAmountForVariable(dto, calculateDto.getProductCode());

        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(),amount);
        return resultMap;
    }
}
