package com.biz.crm.tpm.business.variable.local.register.estore;

import com.biz.crm.tpm.business.examine.circular.sdk.service.ExamineCircularMonthRecordVoService;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.ExamineCircularMonthRecordVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 考核扣款金额
 * @Author: zhouyang
 * @Date: 2023/7/26
 */
@Component
public class ExamineCircularDeductAmountRegister implements FormulaVariableRegister {

    @Autowired
    private ExamineCircularMonthRecordVoService examineCircularMonthVoService;

    @Override
    public String getVariableCode() {
        return "examineCircularDeductAmount";
    }

    @Override
    public String getVariableName() {
        return "考核扣款金额";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerCode(),"客户编码不能为空");
        Validate.notBlank(calculateDto.getYearMonthLy(),"年月不能为空");

        StringBuffer itemKey = new StringBuffer();
        itemKey.append(calculateDto.getCustomerCode());
        itemKey.append(calculateDto.getYearMonthLy());
        ExamineCircularMonthRecordVo vo = examineCircularMonthVoService.findByItemKeyFormulaVariable(itemKey.toString());
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), Objects.nonNull(vo) ? vo.getMonthDeductAmount() : BigDecimal.ZERO);
        return resultMap;
    }
}
