package com.biz.crm.tpm.business.variable.local.register.estore;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 是否试销期
 */
@Service
@Slf4j
public class WhetherTrySalesRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Override
    public String getVariableCode() {
        return "whetherTrySales";
    }

    @Override
    public String getVariableName() {
        return "是否试销期（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerCode(), "客户编码不能为空!");
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码不能为空!");
        Validate.notBlank(calculateDto.getSalesOrganizationCode(), "销售机构编码不能为空!");
        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态不能为空!");
        Validate.notBlank(calculateDto.getChannel(), "渠道不能为空!");
        List<String> customerCodes = new ArrayList<>();
        customerCodes.add(calculateDto.getCustomerCode());
        List<CustomerVo> customerVoList = customerVoService.findBaseByCustomerCodes(customerCodes);
        log.info("是否试销期=====>{}", JSONObject.toJSON(customerVoList));
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(customerVoList)) {
            return resultMap;
        }
        customerVoList = customerVoList.stream().filter(e-> StringUtils.isNotEmpty(e.getIsTestMarket())).collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(customerVoList)){
            String isTestMarket = customerVoList.get(0).getIsTestMarket();
            resultMap.put(this.getVariableCode(), YesOrNoEnum.YES.getCode().equals(isTestMarket) ? BigDecimal.ONE : BigDecimal.ZERO);
        }
        return resultMap;
    }
}
