package com.biz.crm.tpm.business.variable.local.register.estore.common;

import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataImportDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.service.TpmDistributionCustomerAuditDataService;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariablePropertyValueHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import lombok.SneakyThrows;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-23
 */
@Component
public class TpmDistributionCustomerAuditDataHelper {

    @Autowired(required = false)
    private TpmDistributionCustomerAuditDataService tpmDistributionCustomerAuditDataService;

    public void valParam(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码不能为空!");
        Validate.notBlank(calculateDto.getProductCode(), "产品编码不能为空");
        Validate.notBlank(calculateDto.getYearMonthLy(), "年月不能为空");
    }

    @SneakyThrows
    public BigDecimal getValue(CalculateDto calculateDto, String propertyName) {
        TpmDistributionCustomerAuditDataImportDto dto = new TpmDistributionCustomerAuditDataImportDto();
        dto.setCustomerCode(calculateDto.getCustomerErpCode());
        dto.setDistributionCustomerAuditYearMonth(calculateDto.getYearMonthLy());
        dto.setProductCode(calculateDto.getProductCode());

        List<TpmDistributionCustomerAuditDataRespVo> respVos = tpmDistributionCustomerAuditDataService.listForVariable(dto);
        BigDecimal value = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(respVos)) {
            return value;
        }
        for (TpmDistributionCustomerAuditDataRespVo respVo : respVos) {
            BigDecimal v = VariablePropertyValueHelper.getValue(TpmDistributionCustomerAuditDataRespVo.class, propertyName, respVo);
            value = value.add(v);
        }
        return value;
    }

}
