package com.biz.crm.tpm.business.variable.local.register.estore.common;

import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataImportDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariablePropertyValueHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import lombok.SneakyThrows;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 分销客户月度销售表
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-05
 */
@Service
public class TpmDistributionCustomerMonthSaleDataHelper {

    @Autowired(required = false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;

    public void valParam(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码不能为空");
        Validate.notBlank(calculateDto.getSalesOrganizationCode(), "销售机构不能为空");
        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notBlank(calculateDto.getChannel(), "渠道不能为空！");
        Validate.notBlank(calculateDto.getYearMonthLy(), "活动年月不能为空！");
        Validate.notBlank(calculateDto.getProductCode(),"产品编码不能为空！");
    }

    @SneakyThrows
    public BigDecimal getValue(CalculateDto calculateDto, String propertyName) {
        //查询分销客户月度销售表
        TpmDistributionCustomerMonthSaleDto dto = new TpmDistributionCustomerMonthSaleDto();
        dto.setCustomerCode(calculateDto.getCustomerErpCode());
        dto.setSalesInstitutionCode(calculateDto.getSalesOrganizationErpCode());
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setChannelCode(calculateDto.getChannel());
        dto.setDistributionCustomerMonthSaleYearMonth(calculateDto.getYearMonthLy());
        dto.setIncludeProductCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
        List<TpmDistributionCustomerMonthSaleRespVo> respVos = tpmDistributionCustomerMonthSaleService.listForVariable(dto,"month");
        BigDecimal value = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(respVos)) {
            return value;
        }
        for (TpmDistributionCustomerMonthSaleRespVo respVo : respVos) {
            BigDecimal v = VariablePropertyValueHelper.getValue(TpmDistributionCustomerMonthSaleRespVo.class, propertyName, respVo);
            value = value.add(v);
        }
        return value;
    }

}
