package com.biz.crm.tpm.business.variable.local.register.estore.common;

import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariablePropertyValueHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-25
 */
@Component
public class TpmDistributionCustomerSalesDataHelper {

    public static final String YEAR = "year";
    public static final String MONTH = "month";

    @Autowired(required = false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;

    public void val(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码不能为空");
        Validate.notBlank(calculateDto.getSalesOrganizationCode(), "销售机构不能为空");
        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notBlank(calculateDto.getChannel(), "渠道不能为空！");
        Validate.notBlank(calculateDto.getYearMonthLy(), "活动年月不能为空！");
        Validate.notBlank(calculateDto.getProductCode(), "产品编码不能为空！");
    }

    public BigDecimal getValue(CalculateDto calculateDto, String propertyName, String yearMonthType) {
        TpmDistributionCustomerMonthSaleDto dto = new TpmDistributionCustomerMonthSaleDto();
        dto.setCustomerCode(calculateDto.getCustomerErpCode());
        int length = calculateDto.getSalesOrganizationCode().length();
        dto.setSalesInstitutionCode(calculateDto.getSalesOrganizationCode().substring(length - 4, length));
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setChannelCode(calculateDto.getChannel());
        dto.setDistributionCustomerMonthSaleYearMonth(calculateDto.getYearMonthLy());
        dto.setProductCode(calculateDto.getProductCode());

        List<TpmDistributionCustomerMonthSaleRespVo> vos = tpmDistributionCustomerMonthSaleService.listForVariable(dto, yearMonthType);
        BigDecimal value = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(vos)) {
            return value;
        }
        for (TpmDistributionCustomerMonthSaleRespVo respVo : vos) {
            BigDecimal v = VariablePropertyValueHelper.getValue(TpmDistributionCustomerMonthSaleRespVo.class, propertyName, respVo);
            value = value.add(v);
        }
        return value;
    }
}
