package com.biz.crm.tpm.business.variable.local.register.estore.common;

import com.biz.crm.tpm.business.customer.launch.costs.sdk.dto.TpmCustomerLaunchCostsDto;
import com.biz.crm.tpm.business.customer.launch.costs.sdk.service.TpmCustomerLaunchCostsService;
import com.biz.crm.tpm.business.customer.launch.costs.sdk.vo.TpmCustomerLaunchCostsVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariablePropertyValueHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import lombok.SneakyThrows;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 分销客户投放费用表
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-23
 */
@Component
public class TpmDistributionLaunchCostsDataHelper {

    @Autowired(required = false)
    private TpmCustomerLaunchCostsService tpmCustomerLaunchCostsService;

    public void valParam(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码不能为空!");
        Validate.notBlank(calculateDto.getYearMonthLy(), "年月不能为空");
    }

    @SneakyThrows
    public BigDecimal getValue(CalculateDto calculateDto, String propertyName) {
        TpmCustomerLaunchCostsDto dto = new TpmCustomerLaunchCostsDto();
        dto.setCustomerCode(calculateDto.getCustomerErpCode());
        dto.setDistributionCustomerMonthSaleYearMonth(calculateDto.getYearMonthLy());

        List<TpmCustomerLaunchCostsVo> respVos = tpmCustomerLaunchCostsService.listForVariable(dto);
        BigDecimal value = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(respVos)) {
            return value;
        }
        for (TpmCustomerLaunchCostsVo respVo : respVos) {
            BigDecimal v = VariablePropertyValueHelper.getValue(TpmCustomerLaunchCostsVo.class, propertyName, respVo);
            value = value.add(v);
        }
        return value;
    }

}
