package com.biz.crm.tpm.business.variable.local.register.estore.common;

import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataImportDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.service.TpmDistributionCustomerAuditDataService;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo;
import com.biz.crm.tpm.business.platform.rebate.order.sdk.dto.TpmPlatformRebateOrderDto;
import com.biz.crm.tpm.business.platform.rebate.order.sdk.service.TpmPlatformRebateOrderSdkService;
import com.biz.crm.tpm.business.platform.rebate.order.sdk.vo.TpmPlatformRebateOrderVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariablePropertyValueHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import lombok.SneakyThrows;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-23
 */
@Component
public class TpmPlatformRebateOrderDataHelper {

    @Autowired(required = false)
    private TpmPlatformRebateOrderSdkService tpmPlatformRebateOrderSdkService;

    public void valParam(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码不能为空!");
        Validate.notBlank(calculateDto.getProductCode(), "产品编码不能为空");
        Validate.notBlank(calculateDto.getYearMonthLy(), "年月不能为空");
    }

    @SneakyThrows
    public BigDecimal getValue(CalculateDto calculateDto, String propertyName) {
        TpmPlatformRebateOrderDto dto = new TpmPlatformRebateOrderDto();
        dto.setCustomerCode(calculateDto.getCustomerErpCode());
        dto.setYearMonthLy(calculateDto.getYearMonthLy());
        dto.setIncludeSapProductCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
        List<TpmPlatformRebateOrderVo> respVos = tpmPlatformRebateOrderSdkService.listForVariable(dto);
        BigDecimal value = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(respVos)) {
            return value;
        }
        for (TpmPlatformRebateOrderVo respVo : respVos) {
            BigDecimal v = VariablePropertyValueHelper.getValue(TpmPlatformRebateOrderVo.class, propertyName, respVo);
            value = value.add(v);
        }
        return value;
    }
}
