package com.biz.crm.tpm.business.variable.local.register.mainOneDaySaleData;

import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author ：dengwei
 * @date ：Created in 2023/1/14 15:42
 * @description：奶卡折后订单额（toB）
 */
@Service
@Slf4j
public class MilkCardDiscountBehindOrderAmountToBRegister implements FormulaVariableRegister {


    @Autowired(required = false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;

    @Override
    public String getVariableCode() {
        return "milkCardDiscountBehindOrderAmountToB";
    }

    @Override
    public String getVariableName() {
        return "奶卡折后订单额（toB）（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

//        Validate.notNull(calculateDto.getCustomerCode(),"客户编码不能为空");
        Validate.notNull(calculateDto.getYearMonthLy(),"活动所属年月不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(calculateDto.getSalesOrgCode()) || !CollectionUtils.isEmpty(calculateDto.getCustomerCodeList()),
                "[奶卡折后订单额（toB）] 销售组织编码和客户编码不能同时为空！");
        MainOnedaySalesDataDto mainOnedaySalesDataDto = new MainOnedaySalesDataDto();
        mainOnedaySalesDataDto.setCustomerCodeList(com.google.common.collect.Lists.newArrayList(calculateDto.getCustomerCodeList()));
        mainOnedaySalesDataDto.setYearMonthLy(calculateDto.getYearMonthLy().replaceAll("-", ""));
        if (CollectionUtils.isEmpty(calculateDto.getCustomerCodeList())) {
            mainOnedaySalesDataDto.setSalesOrgCode(calculateDto.getSalesOrgCode());
        }
        List<MainOnedaySalesDataVo> mainOnedaySalesDataVos = mainOnedaySaleDataService.listMainOnedaySalesData(mainOnedaySalesDataDto);
        if(CollectionUtils.isEmpty(mainOnedaySalesDataVos)){
            Map<String,BigDecimal> resultMap = new HashMap<>();
            resultMap.put(this.getVariableCode(),BigDecimal.ZERO);
            return resultMap;
        }
        Map<String,BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(),mainOnedaySalesDataVos.stream().map(MainOnedaySalesDataVo::getMilkCardDiscountBehindOrderAmountToB).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        return resultMap;
    }
}
