package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import liquibase.pro.packaged.E;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 * 活动力度
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-16
 */
@Service
@Slf4j
public class ActivityIntensityRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "activityIntensity";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "活动力度（主体）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getDetailPlanItemCode(), "活动细案明细编码不能为空！");
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        List<ActivityDetailPlanItemVo> vos = activityDetailPlanItemSdkService.listByItemCodeList(Lists.newArrayList(calculateDto.getDetailPlanItemCode()));
        if (CollectionUtils.isEmpty(vos)) {
            return resultMap;
        }
        String activityIntensityStr = vos.get(0).getActivityIntensity();
        if (StringUtils.isEmpty(activityIntensityStr)) {
            return resultMap;
        }
        BigDecimal activityIntensity = BigDecimal.ZERO;
        if (activityIntensityStr.contains("/")) {
            String[] vars = activityIntensityStr.split("/");
            Validate.isTrue(vars.length == 2, "活动力度[%s]格式错误！", activityIntensityStr);
            BigDecimal var1;
            BigDecimal var2;
            try {
                var1 = new BigDecimal(vars[0]);
                var2 = new BigDecimal(vars[1]);
            } catch (Exception e) {
                throw new RuntimeException("活动力度[" + activityIntensityStr + "]格式错误！");
            }
            Validate.isTrue(var2.compareTo(BigDecimal.ZERO) != 0, "活动力度[%s]分子不能为0！", activityIntensityStr);
            activityIntensity = var1.divide(var2, 8, RoundingMode.HALF_UP);
        } else {
            try {
                activityIntensity = new BigDecimal(activityIntensityStr).setScale(8, RoundingMode.HALF_UP);
            } catch (Exception e) {
                throw new RuntimeException("活动力度[" + activityIntensityStr + "]格式错误！");
            }
        }
        resultMap.put(this.getVariableCode(), activityIntensity);
        return resultMap;
    }
}
