package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariableCommonConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-27
 */
@Service
@Slf4j
public class ActivityProductActualMonthStockQuantityRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "activityProductActualMonthStockQuantity";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "活动产品实际全月进货件数（主体）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        MainOnedaySalesDataDto salesDataDto = new MainOnedaySalesDataDto();

        //参数
        Validate.notBlank(calculateDto.getYearMonthLy(), "年月为空！");
        Validate.notEmpty(calculateDto.getCustomerCodeList(), "客户编码不能为空");
        salesDataDto.setYearMonthLy(calculateDto.getYearMonthLy().replaceAll("-", ""));
        salesDataDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        salesDataDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesDataDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());

        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            salesDataDto.setProductCodes(Arrays.asList(calculateDto.getProductCode().split(",")));
        } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
            salesDataDto.setProductItemCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
            salesDataDto.setProductCategoryCode(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode()) && !StringUtils.equals(VariableCommonConstants.allBrandCode, calculateDto.getBrandCode())) {
            salesDataDto.setProductBrandCode(calculateDto.getBrandCode());
        }

        //主体日销售报表:调整后销量（件）
        List<MainOnedaySalesDataVo> salesDataVos = mainOnedaySaleDataService.listMainOnedaySalesData(salesDataDto);
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(salesDataVos)) {
            return resultMap;
        }
        BigDecimal total = salesDataVos.stream().filter(e -> Objects.nonNull(e.getMinusSaleQuantity())).map(MainOnedaySalesDataVo::getMinusSaleQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }
}
