package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemTerminalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanReportVo;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmProfitabilityAnalysisDto;
import com.biz.crm.tpm.business.third.system.sdk.service.TpmProfitabilityAnalysisService;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmProfitabilityAnalysisVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariableCommonConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-23
 */
@Slf4j
@Service
public class ActivityPromotionApplyStoreDeliveryQuantityRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required = false)
    private TpmProfitabilityAnalysisService tpmProfitabilityAnalysisService;
    @Autowired(required = false)
    private ActivityDetailPlanItemTerminalService activityDetailPlanItemTerminalService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "activityPromotionApplyStoreDeliveryQuantity";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "促销申请门店出库件数（活动）（主体）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getDetailPlanItemCode(), "活动细案明细编码不能为空");
        Validate.notNull(calculateDto.getStartTimeOrDate(), "活动开始时间不能为空");
        Validate.notNull(calculateDto.getEndTimeOrDate(), "活动结束时间不能为空");
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码不能为空");
        Validate.notBlank(calculateDto.getFirstChannelCode(), "一级渠道编码不能为空");
        if ("Q".equals(calculateDto.getFirstChannelCode())) {
            //如果一级渠道是Q时，取099所有渠道下的数据
            calculateDto.setFirstChannelCode(null);
        }

        List<ActivityDetailPlanItemTerminalDto> detailPlanItemTerminalDtos =
                activityDetailPlanItemTerminalService.findTerminalListByDetailPlanItemCodes(Lists.newArrayList(calculateDto.getDetailPlanItemCode()));

        List<String> includeServiceCodes = new ArrayList<>();
        if (!CollectionUtils.isEmpty(detailPlanItemTerminalDtos)) {
            includeServiceCodes = detailPlanItemTerminalDtos.stream().map(ActivityDetailPlanItemTerminalDto::getTerminalCode).filter(terminalCode -> StringUtils.isNotEmpty(terminalCode)).collect(Collectors.toList());
        }

        List<SalesOrgSubComOrgVo> subComOrgVos = salesOrgSubComOrgService.listBySubComOrgCodeList(Lists.newArrayList(calculateDto.getCustomerErpCode()));
        Validate.notEmpty(subComOrgVos, "未获取到分子公司与销售机构对应关系");
        String salesOrgCode = subComOrgVos.get(0).getSalesOrgCode();

        TpmProfitabilityAnalysisDto dto = new TpmProfitabilityAnalysisDto();
        dto.setAccountDateBegin(DateUtil.format(calculateDto.getStartTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY).replaceAll("-", ""));
        dto.setAccountDateEnd(DateUtil.format(calculateDto.getEndTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY).replaceAll("-", ""));
        dto.setCompanyCode(salesOrgCode);
        dto.setSpartCode(VariableCommonConstants.spartCode);
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            dto.setMaterialCodes(Arrays.asList(calculateDto.getProductCode().split(",")));
        } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
            dto.setItemCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
            dto.setCategoryCode(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode()) && !StringUtils.equals(VariableCommonConstants.allBrandCode, calculateDto.getBrandCode())) {
            dto.setBrandCode(calculateDto.getBrandCode());
        }/* else {
            //先取产品编码，如果产品编码为空，则去查看品牌编码，品牌编码为130000，则取全部产品销量和
            Validate.isTrue(StringUtils.equals(VariableCommonConstants.allBrandCode, calculateDto.getBrandCode()), "产品编码不能为空");
        }*/
        dto.setChannelCode(calculateDto.getFirstChannelCode());
        dto.setIncludeServiceCodes(includeServiceCodes);
        List<TpmProfitabilityAnalysisVo> vos = tpmProfitabilityAnalysisService.listForVariable(dto);

        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(vos)) {
            return resultMap;
        }
        BigDecimal total = vos.stream()
                .filter(e -> Objects.nonNull(e.getSalesNum()))
                .map(TpmProfitabilityAnalysisVo::getSalesNum)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }
}
