package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 试销期
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-16
 */
@Service
@Slf4j
public class AllProductAllMonthDiscountTaskApprovedRateOutRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "allProductAllMonthDiscountTaskApprovedRateOut";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "全品全月折后任务量达成率（剔量）（主体）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        MainOnedaySalesDataDto salesDataDto = new MainOnedaySalesDataDto();
        SalesGoalDto salesGoalDto = new SalesGoalDto();

        //参数
        Validate.notBlank(calculateDto.getYearMonthLy(), "年月为空！");
        salesDataDto.setYearMonthLy(calculateDto.getYearMonthLy().replaceAll("-", ""));
        salesGoalDto.setYearMonthLy(calculateDto.getYearMonthLy());
        salesDataDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesGoalDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesDataDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesGoalDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        if (!CollectionUtils.isEmpty(calculateDto.getCustomerCodeList())) {
            salesDataDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
            salesGoalDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        } else if (StringUtils.isNotEmpty(calculateDto.getSalesGroupCode())) {
            salesDataDto.setSalesOrgProvinceCode(calculateDto.getSalesGroupCode());
            salesGoalDto.setSalesOrgProvinceCode(calculateDto.getSalesGroupCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getSalesRegionCode())) {
            salesDataDto.setSalesOrgRegionCode(calculateDto.getSalesRegionCode());
            salesGoalDto.setSalesOrgRegionCode(calculateDto.getSalesRegionCode());
        } else {
            throw new RuntimeException("客户编码、销售组、销售部门全部为空");
        }

        //剔除产品
        ProductDto dto = new ProductDto();
        List<String> includeMainCategoryList = new ArrayList<>();
        includeMainCategoryList.add("1");
        includeMainCategoryList.add("2");
        includeMainCategoryList.add("3");
        dto.setIncludeMainCategoryList(includeMainCategoryList);
        List<ProductVo> productVos = productVoService.queryCondition(dto);
        if (!CollectionUtils.isEmpty(productVos)) {
            List<String> excludeProductCodeList = productVos.stream().map(ProductVo::getProductCode).distinct().collect(Collectors.toList());
            salesDataDto.setExcludeProductCodeList(excludeProductCodeList);
            salesGoalDto.setExcludeProductCodeList(excludeProductCodeList);
        }

        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);

        //主体日销售报表:调减后折后含税销额（含奶卡）
        List<MainOnedaySalesDataVo> salesDataVos = mainOnedaySaleDataService.listMainOnedaySalesData(salesDataDto);
        BigDecimal minusDiscountBehindTaxSaleAmountIn = salesDataVos.stream().filter(e -> Objects.nonNull(e.getMinusDiscountBehindTaxSaleAmountIn())).map(MainOnedaySalesDataVo::getMinusDiscountBehindTaxSaleAmountIn).reduce(BigDecimal.ZERO, BigDecimal::add);

        //销售任务:合同量的“折后任务额”
        salesGoalDto.setYearSalesTypeCode("contract");
        List<SalesGoalVo> salesGoalVos = salesGoalService.listForVariableCal(salesGoalDto);
        BigDecimal deliveryDiscountSalesAmount = salesGoalVos.stream().filter(e -> Objects.nonNull(e.getDeliveryDiscountSalesAmount())).map(SalesGoalVo::getDeliveryDiscountSalesAmount).reduce(BigDecimal.ZERO, BigDecimal::add);

        if (BigDecimal.ZERO.compareTo(minusDiscountBehindTaxSaleAmountIn) == 0 || BigDecimal.ZERO.compareTo(deliveryDiscountSalesAmount) == 0) {
            return resultMap;
        }
        BigDecimal rate = minusDiscountBehindTaxSaleAmountIn.divide(deliveryDiscountSalesAmount, 8, BigDecimal.ROUND_HALF_UP);
        resultMap.put(this.getVariableCode(), rate);
        return resultMap;
    }
}
